#!/bin/sh
# cp30c daemon manager

if [ "$1" = "" ]; then
	echo "Usage: $0 start|stop|restart|help"
	exit 1
fi

CPHOME=homedir

ERROR=1
SUCCESS=0

cd $CPHOME

type='0'
if [ -f /etc/systemd/system/cp30c.service ]; then
	type='1'
fi
if [ $type = '0' -a -f /etc/init.d/cp30c ]; then
	type='2'
fi

trap "" 15
trap "" 1

case $1 in

start|-start)
# startup service
	# must be root
	if [ "`id -u -n`" != "root" ]
        	then
        	echo "You must be the root user to run this option."
        	exit
	fi
	if ps -C cp30c.http --no-headers -o pid >/dev/null; then
		echo "CirrusPrint client is already running"
		exit
	fi

	/usr/bin/cp30c -update

	echo "Starting the cp30c service"
	case $type in
		1)
			systemctl start cp30c
			;;
		2)
			service cp30c start
			;;
		*)
			nohup $CPHOME/cp30c.http -start &
			;;
	esac

	sleep 1
	count=0
	until [ -s startup.log -o -s startup.err ]
	do
			printf "."
			sleep 1
			count=`expr $count + 1`
	done
	[ "$count" != "0" ] && echo ""
	[ -s startup.err ] && cat startup.err
	[ -s startup.log ] && cat startup.log
	;;

stop|-stop)
# shutdown service
	# must be root
	if [ "`id -u -n`" != "root" ]
        	then
        	echo "You must be the root user to run this option."
        	exit
	fi

	echo "Stopping the cp30c service"
	case $type in
		1)
			systemctl stop cp30c
			;;
		2)
			service cp30c stop
			;;
		*)
			$CPHOME/cp30c.http -stop
			;;
	esac

	x=`ps -C cp30c.http --no-headers -o pid`
	tries=0
	if [ "$x" != "" -a "$tries" -lt 10 ]; then
		sleep 2
		tries=`expr $tries + 1`
		x=`ps -C cp30c.http --no-headers -o pid`
	fi
	if [ "$x" = "" ]; then
		echo "CirrusPrint 3.0 Client stopped"
	fi
	if [ "$x" != "" ]; then
		kill $x
		echo "CirrusPrint 3.0 Client killed"
	fi

	;;

restart|-restart )
# restart the service
	if [ "`id -u -n`" != "root" ]
        	then
        	echo "You must be the root user to run this option."
        	exit
	fi
	$0 stop
	sleep 2
	$0 start
	;;

update|-update )
	if [ "`id -u -n`" != "root" ]
        	then
        	echo "You must be the root user to run this option."
        	exit
	fi
	if [ -f updates/cp30c.linux.tar.gz ]; then
		echo "`date` Updating cp30c..." >cp30c.updates.log
		echo "Updating cp30c..."
		umask 0
		tar xf updates/cp30c.linux.tar.gz 2>>cp30c.updates.log
		chmod 555 cp30c.http
		chmod 755 *.sh
		chmod 666 *.ini
		rm -rf updates/
		./setup.sh -yes
		echo "`date` Update complete" >>cp30c.updates.log
		echo "Update complete"
	fi
	;;

help|-help|-\? )
	echo "Run as root, or with sudo:"
	echo " 'cp30c -start' to start the CirrusPrint client service"
	echo " 'cp30c -stop' to stop the service"
	echo " 'cp30c -restart' to stop then start the service"
	echo ""
	echo "More information at https://cirrusprint.com"
	;;

*)
	$CPHOME/cp30c.http "$@"
	;;

esac
	
exit 0

